/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.engine;

import frc.emul.api.engine.DebugEvent;
import frc.emul.api.engine.IDebugEngine;
import frc.emul.api.engine.IDebugEventListener;
import frc.emul.api.engine.IDebugEventManager;
import frc.emul.api.engine.IEngineBreakpoint;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class VectrexEngineEventMgr
implements IDebugEventManager {
    private final List<IDebugEventListener> listeners = new ArrayList<IDebugEventListener>();

    public final void fireResumeEvent(IDebugEngine iDebugEngine, DebugEvent.Reason reason) {
        this.fire(iDebugEngine, DebugEvent.Kind.RESUME, reason, null);
    }

    public final void fireSuspendEvent(IDebugEngine iDebugEngine, DebugEvent.Reason reason, IEngineBreakpoint iEngineBreakpoint) {
        this.fire(iDebugEngine, DebugEvent.Kind.SUSPEND, reason, iEngineBreakpoint);
    }

    public final void fireTerminateEvent(IDebugEngine iDebugEngine, DebugEvent.Reason reason) {
        this.fire(iDebugEngine, DebugEvent.Kind.TERMINATE, reason, null);
    }

    public final void fireCreateEvent(IDebugEngine iDebugEngine, DebugEvent.Reason reason) {
        this.fire(iDebugEngine, DebugEvent.Kind.CREATE, reason, null);
    }

    public void addDebugListener(IDebugEventListener iDebugEventListener) {
        this.listeners.add(iDebugEventListener);
    }

    public void removeDebugListener(IDebugEventListener iDebugEventListener) {
        this.listeners.remove(iDebugEventListener);
    }

    private void fire(IDebugEngine iDebugEngine, DebugEvent.Kind kind, DebugEvent.Reason reason, IEngineBreakpoint iEngineBreakpoint) {
        if (!kind.accepts(reason)) {
            throw new InvalidParameterException("Incompatible reason for " + (Object)((Object)kind) + " event : " + (Object)((Object)reason));
        }
        if (DebugEvent.Reason.BREAKPOINT == reason) {
            if (iEngineBreakpoint == null) {
                throw new InvalidParameterException("No breakpoint specified for " + (Object)((Object)kind) + " event : " + (Object)((Object)reason));
            }
        } else if (iEngineBreakpoint != null) {
            throw new InvalidParameterException("Breakpoint specified for " + (Object)((Object)kind) + " event : " + (Object)((Object)reason));
        }
        DebugEvent debugEvent = new DebugEvent(iDebugEngine, kind, reason, iEngineBreakpoint);
        for (IDebugEventListener iDebugEventListener : this.listeners) {
            iDebugEventListener.debugEventFired(debugEvent);
        }
    }
}

